/**HEADER********************************************************************
* 
* Copyright (c) 2010 Linear Tech Corporation;
* All Rights Reserved
*
* Copyright (c) 2008 Freescale Semiconductor;
* All Rights Reserved
*
* Copyright (c) 1989-2008 ARC International;
* All Rights Reserved
*
*************************************************************************** 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************
*
* $FileName: httpdsrv.c$
* $Version : 3.5.26.0$
* $Version : Custom for LTC Board Demo Suite
* $Date    : Sep-10-2010$
*
* Comments:
*
*   Example HTTP server using RTCS Library, also Initializes the LTC Board.
*
*END************************************************************************/

#include <mqx.h>
#include <bsp.h>
#include <rtcs.h>

#include <ltctwrutils.h>
#include <httpd.h>
#include <httpdsrv.h>
#include <tfs.h>
#include <cgi.h>
#include <enet_wifi.h>
#include <config.h>

#include <select.h>

#include "usb_task.h"

#include <logging.h>

#if BSPCFG_ENABLE_ADC
#include "adc.h"
#endif


#define HTTPD_SEPARATE_TASK     0


#if ! BSPCFG_ENABLE_IO_SUBSYSTEM
#error This application requires BSPCFG_ENABLE_IO_SUBSYSTEM defined non-zero in user_config.h. Please recompile BSP with this option.
#endif


#ifndef BSP_DEFAULT_IO_CHANNEL_DEFINED
#error This application requires BSP_DEFAULT_IO_CHANNEL to be not NULL. Please set corresponding BSPCFG_ENABLE_TTYx to non-zero in user_config.h and recompile BSP with this option.
#endif


#ifndef MQX_DEVICE
#define MQX_DEVICE BSP_DEFAULT_IO_CHANNEL
#endif



const HTTPD_ROOT_DIR_STRUCT root_dir[] = {
    { "", "tfs:" },
    { "usb", "c:" },
    { 0, 0 }
};



FILE_PTR output_port = NULL;


/*TASK*-----------------------------------------------------------------
*
* Function Name  : http_task
* Returned Value : void
* Comments       :
*
*END------------------------------------------------------------------*/
void http_task(uint_32 temp) {
    int_32            error;
    _enet_handle      ehandle;
    _rtcs_if_handle   ihandle;
    _enet_address     address;
    HTTPD_STRUCT *server;
    extern const HTTPD_CGI_LINK_STRUCT cgi_lnk_tbl[];
    extern const HTTPD_FN_LINK_STRUCT fn_lnk_tbl[];  //Gotta add the fn_lnk_tbl for the callback function
    extern const TFS_DIR_ENTRY tfs_data[];
    HTTPD_PARAMS_STRUCT *params;

   

#if BSPCFG_ENABLE_GPIODEV
    const uint_32 output_set[] = {
        LED_1 | GPIO_PIN_STATUS_0,
        LED_2 | GPIO_PIN_STATUS_0,
        LED_3 | GPIO_PIN_STATUS_0,
        LED_4 | GPIO_PIN_STATUS_0,
        GPIO_LIST_END
    };
#endif    

    /* Open and set port TC as output to drive LEDs (LED10 - LED13) */
#if BSPCFG_ENABLE_GPIODEV
    output_port = fopen("gpio:write", (char_ptr) &output_set);
#endif        


    _time_delay (2000);


    /* runtime RTCS configuration (we have more than 32kB)*/
    _RTCSPCB_init = 4;
    _RTCSPCB_grow = 2;
    _RTCSPCB_max = 6;
    _RTCS_msgpool_init = 4;
    _RTCS_msgpool_grow = 2;
    _RTCS_msgpool_max  = 8;
    _RTCS_socket_part_init = 4;
    _RTCS_socket_part_grow = 2;
    _RTCS_socket_part_max  = 6;
   
    
    _RTCSTASK_stacksize = 2200;

    error = RTCS_create();

    ENET_get_mac_address(DEMOCFG_DEFAULT_DEVICE, ENET_IPADDR, address);
    error = ENET_initialize(DEMOCFG_DEFAULT_DEVICE, address, 0, &ehandle);

    
    error = RTCS_if_add(ehandle, RTCS_IF_ENET, &ihandle);
    error = RTCS_if_bind(ihandle, ENET_IPADDR, ENET_IPMASK);
        
    error = _io_tfs_install("tfs:", tfs_data);
    
    
    printf("\nPreparing http server...\n");
    
    //Set up the HTTP Server
    params = httpd_default_params(NULL);
    if (params) {
        params->root_dir = (HTTPD_ROOT_DIR_STRUCT*)root_dir;
        params->index_page = "\\index.html";


        server = httpd_init(params);
    }
	
	//Set up the CGI handler table
    HTTPD_SET_PARAM_CGI_TBL(server, (HTTPD_CGI_LINK_STRUCT*)cgi_lnk_tbl);
    
    //Need to hook up the link table for dynamic web pages
    HTTPD_SET_PARAM_FN_TBL(server, (HTTPD_FN_LINK_STRUCT*)fn_lnk_tbl);
    
    //Initialize the Tower (populate the struct)
    printf("Initializing Parameters...\n");
    LTCTWR_InitializeParameters();

    printf("Run http server...\n");
#if HTTPD_SEPARATE_TASK || !HTTPDCFG_POLL_MODE    
    httpd_server_run(server);
    
    /* user stuff come here */

    _task_block();
#else    
    while (1) {
        httpd_server_poll(server, 1);
        
        /* user stuff come here - only non blocking calls */
    }
#endif
}
